/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DatabaseSystem;
import com.mckoi.database.StatementTree;
import com.mckoi.debug.DebugLogger;
import com.mckoi.util.Cache;

public final class StatementCache {
    private DatabaseSystem system;
    private Cache cache;

    public StatementCache(DatabaseSystem system, int hash_size, int max_size, int clean_percentage) {
        this.system = system;
        this.cache = new Cache(hash_size, max_size, clean_percentage);
    }

    public final DebugLogger Debug() {
        return this.system.Debug();
    }

    public synchronized void put(String query_string, StatementTree statement_tree) {
        if (this.cache.get(query_string = query_string.trim()) == null) {
            try {
                Object cloned_tree = statement_tree.clone();
                this.cache.put(query_string, cloned_tree);
            }
            catch (CloneNotSupportedException e) {
                this.Debug().writeException(e);
                throw new Error("Unable to clone statement tree: " + e.getMessage());
            }
        }
    }

    public synchronized StatementTree get(String query_string) {
        Object ob = this.cache.get(query_string = query_string.trim());
        if (ob != null) {
            try {
                StatementTree cloned_tree = (StatementTree)ob;
                return (StatementTree)cloned_tree.clone();
            }
            catch (CloneNotSupportedException e) {
                this.Debug().writeException(e);
                throw new Error("Unable to clone statement tree: " + e.getMessage());
            }
        }
        return null;
    }
}

